// This file is available in electronic form at http://www.psa.es/sdg/sunpos.htm
//  https://forum.arduino.cc/t/import-sun-position-algorithm-to-arduino/458084  -- code about 2/3 down the page
// link  https://lastminuteengineers.com/tm1637-arduino-tutorial/
// On the web calculations https://findmyshadow.com/
// This file works

//  Set the brightness to 5 (0=dimmest 7=brightest)
//  display.setBrightness(5);
//  Set all segments ON
//	display.setSegments(allON);
//	delay(2000);
//	display.clear();
//	display.showNumberDec(9);
//	display.showNumberDec(-12);			// Prints _-12
//	display.showNumberDec(-999);		// Prints -999
//	display.showNumberDec(31, false);	// Prints __31
//	display.showNumberDec(31, true);	// Prints 0031
//	display.showNumberDec(14, false, 2, 1);	// Prints _14_
//	display.showNumberDec(-5, false, 3, 0);	// Prints _-5_
//  Prints 12:34
//	display.showNumberDecEx(1234, 0b11100000, false, 4, 0);
//  Prints 15°C
//	int temperature = 15;
//	display.showNumberDec(temperature, false, 2, 0);
//	display.setSegments(celsius, 2, 2);
//  Prints dOnE
//	display.setSegments(done);

// LED Segments
//   ________________________
//  |          SEG_A         | 
//  |  SEG_F |       | SEG_B |
//  |          SEG_G         | 
//  |  SEG_E |       | SEG_C |
//  |          SEG_D         |
//  |________________________|
// Seg A, value = 1, B=2, C=4, D=8, E=16, F=32, G=64, Total = 127


#ifndef __SUNPOS_H
#define __SUNPOS_H
 
// Include the library
#include <TM1637Display.h>

// Define the connections pins of TM1637 LED Display
#define CLK 5
#define DIO 4

// Create a display object of type TM1637Display
TM1637Display display = TM1637Display(CLK, DIO);

// Create an array that turns all segments ON
const uint8_t allON[] = {0xff, 0xff, 0xff, 0xff};

// Create an array that turns all segments OFF
const uint8_t allOFF[] = {0x00, 0x00, 0x00, 0x00};
// Create an array that sets individual segments per digit to display:-
const uint8_t El[] = {121,72,0,0};                  // word "El"
const uint8_t Az[] = {119,72,0,0};                  // word "Az"
const uint8_t none[] = {84,92,84,121};              // word "nonE"
const uint8_t NO[] = {55,63,0,0};                   // word "NO."
const uint8_t sig[] = {109,48,61,0};                // word "SIg."
const uint8_t GPS[] = {61,115,109,0};               // word "GPS."
const uint8_t Time[] = {118,80,0,0};                  // word "Hr__"
const uint8_t no[] = {84,92,0,0};                   // word "no__."
const uint8_t no1[] = {84,92,0,56};                 // word "no_L."
const uint8_t no2[] = {92,0,56,92};                 // word "o_Lo."
const uint8_t Loc[] = {0,56,92,88};                 // word "_Loc."
const uint8_t Locn[] = {56,92,88,84};               // word "Locn"
const uint8_t Loc1[] = {92,88,84,0};                // word "ocn_"
const uint8_t Loc2[] = {88,84,0,84};                // word "cn_n"
const uint8_t Loc3[] = {84,0,84,92};                // word "n_no"
const uint8_t Loc4[] = {0,84,92,0};                 // word "_no_"
//const uint8_t Loc5[] = {0,84,92,0};               // word "_no_"

// Create an array that sets individual segments per digit to display the word "dOnE"
const uint8_t done[] = {
  SEG_B | SEG_C | SEG_D | SEG_E | SEG_G,           // d
  SEG_A | SEG_B | SEG_C | SEG_D | SEG_E | SEG_F,   // O
  SEG_C | SEG_E | SEG_G,                           // n
  SEG_A | SEG_D | SEG_E | SEG_F | SEG_G            // E
};

// Create degree celsius symbol
const uint8_t celsius[] = {
  SEG_A | SEG_B | SEG_F | SEG_G,  // Degree symbol
  SEG_A | SEG_D | SEG_E | SEG_F   // C
};





// Declaration of some constants for Sun Calculations
#define pi    3.14159265358979323846
#define twopi (2*pi)
#define rad   (pi/180)
#define dEarthMeanRadius     6371.01	// In km
#define dAstronomicalUnit    149597890	// In km

struct cTime
{
	int iYear;
	int iMonth;
	int iDay;
	double dHours;
	double dMinutes;
	double dSeconds;
};

struct cLocation
{
	double dLatitude;
	double dLongitude;
};

struct cSunCoordinates
{
	double dZenithAngle;
	double dAzimuth;
};

void sunpos(cTime udtTime, cLocation udtLocation, cSunCoordinates *udtSunCoordinates);

#endif
#include <math.h>
#include <TinyGPS++.h>
#include <SoftwareSerial.h>
#include <SolarPosition.h>
#include <Time.h>

// some test positions:
float Latitude= 33.673606;                           // Furfy GPS Locations to satify assembler (Compiler)
float Longitude= -117.555084;                        //  Furfy GPS Locations to satify assembler (Compiler)
char location[] = "Katanning";                       //  Use in the local time printout
int RXPin = 7;                                       // Rx Pin of the NEO-6M GPS
int TXPin = 6;                                       // Tx Pin of the NEO-6M GPS
float elevation;
float azimuth;
int timezone = 8;
float heretime;                                     // Used in the calculation of the local time 
TinyGPSPlus gps;
SoftwareSerial SerialGPS(RXPin, TXPin);

// number of decimal digits to print
const uint8_t digits = 3;

cSunCoordinates coord;

cTime udtTime = {2023, 03, 16, 8, 15, 00};         // data here is just to create the array
cLocation udtLocation = {33.673625,-117.555099};   // data here is just to create the array

// program begins

void setup() {
  Serial.begin(9600);
  SerialGPS.begin(9600);
  // Set the brightness to 5 (0=dimmest 7=brightest)
	display.setBrightness(5);
	// Set all segments ON
	display.setSegments(allON);
	display.clear();
}


void loop() {
  while (SerialGPS.available() > 0)
    if (gps.encode(SerialGPS.read()))
      showData();
  if (millis() > 5000 && gps.charsProcessed() < 10)
  {
    Serial.println("GPS NOT DETECTED!");

    while(true);
  }
}


void CalculateData() {
  sunpos(udtTime, udtLocation, &coord);
}


void showData() {
  CalculateData();
  Serial.print("Date: ");
  if (gps.date.isValid())
  {
    udtTime.iDay = (gps.date.day());
    Serial.print(udtTime.iDay);
    Serial.print("/");
    udtTime.iMonth = (gps.date.month());
    Serial.print(udtTime.iMonth);
    Serial.print("/");
    udtTime.iYear = (gps.date.year());
    Serial.println(udtTime.iYear);
  }
  else
  {
    Serial.println("Not Available  --  Waiting for GPS Data");
  }
    if (gps.time.isValid()) {
    Serial.print("UTC Time: ");
    if (gps.time.hour() < 10) Serial.print(F("0"));
    udtTime.dHours = (gps.time.hour());
    Serial.print(udtTime.dHours, 0);    
    Serial.print(":");
    if (gps.time.minute() < 10) Serial.print(F("0"));
    udtTime.dMinutes = (gps.time.minute());
    Serial.print(udtTime.dMinutes, 0);
    Serial.print(":");
    if (gps.time.second() < 10) Serial.print(F("0"));
    udtTime.dSeconds = (gps.time.second());    
    Serial.println(udtTime.dSeconds, 0);
    Serial.print(location);
    Serial.print(F(" Time: "));
    if ((udtTime.dHours + timezone) >= 24 ) {
    heretime = udtTime.dHours  + timezone - 24;
    Serial.print(heretime,0);    
    } else {
    Serial.print(udtTime.dHours + timezone,0); 
    }
    Serial.print(":");
    if (gps.time.minute() < 10) Serial.print(F("0"));
    Serial.print(udtTime.dMinutes, 0);
    Serial.print(":");
    if (gps.time.second() < 10) Serial.print(F("0"));
    Serial.println(udtTime.dSeconds, 0);
    udtTime.dSeconds = (gps.time.second());
        display.setSegments(Time);
    delay(1000);
    if ((udtTime.dHours + timezone) >= 24 ) {
    heretime = udtTime.dHours  + timezone - 24;
    } else {
    heretime = (udtTime.dHours + timezone); 
    }
    heretime = heretime * 100;            //     Hours 
    heretime = heretime +udtTime.dMinutes;      //   + Minutes
    display.showNumberDecEx(heretime, 0b11100000, true, 4, 0);
        delay(1000);
  }
  else
  {
   Serial.println("Time not available  --  Waiting for GPS Data");
  }
  //Serial.println();
  //delay(5000);

  if (gps.location.isValid())  {
    delay (3000);                           // First time ready, give it time to calculate El, Az etc
    Serial.print("Latitude: ");
    udtLocation.dLatitude = (gps.location.lat());
    Serial.println(udtLocation.dLatitude,6);
    Serial.print("Longitude: ");    
    udtLocation.dLongitude = (gps.location.lng());
    Serial.println(udtLocation.dLongitude,6);
    Serial.print("Altitude: ");
    Serial.println(gps.altitude.meters());
    Serial.print(F("Elevation = "));
    Serial.println(90 - coord.dZenithAngle);
    Serial.print(F("Azimuth = "));
    Serial.println(coord.dAzimuth);
    Serial.print("Zenith angle: ");
    Serial.println(coord.dZenithAngle);
    // Sent to 7 segment LED

    delay (3000);                           // Not really neaded
    display.setSegments(El);
    delay(1000);
    display.showNumberDec(90 - coord.dZenithAngle);
    delay (3000);
    display.setSegments(Az);
    delay(1000);
    display.showNumberDec(coord.dAzimuth);
    delay(3000);  
  }
  else
  {
    Serial.println("Location not available  --  Waiting for GPS Data");
    display.setSegments(no);
    delay(500);
    display.setSegments(Locn);
    delay(500);
  }
  Serial.println();
}


void sunpos(cTime udtTime, cLocation udtLocation, cSunCoordinates *udtSunCoordinates)
{
  // Main variables
  double dElapsedJulianDays;
  double dDecimalHours;
  double dEclipticLongitude;
  double dEclipticObliquity;
  double dRightAscension;
  double dDeclination;

  // Auxiliary variables
  double dY;
  double dX;

  // Calculate difference in days between the current Julian Day
  // and JD 2451545.0, which is noon 1 January 2000 Universal Time
  {
    double dJulianDate;
    long int liAux1;
    long int liAux2;
    // Calculate time of the day in UT decimal hours
    dDecimalHours = udtTime.dHours + (udtTime.dMinutes + udtTime.dSeconds / 60.0 ) / 60.0;
    // Calculate current Julian Day
    liAux1 = (udtTime.iMonth - 14) / 12;
    liAux2 = (1461 * (udtTime.iYear + 4800 + liAux1)) / 4 + (367 * (udtTime.iMonth - 2 - 12 * liAux1)) / 12 - (3 * ((udtTime.iYear + 4900 + liAux1) / 100)) / 4 + udtTime.iDay - 32075;
    dJulianDate = (double)(liAux2) - 0.5 + dDecimalHours / 24.0;
    // Calculate difference between current Julian Day and JD 2451545.0
    dElapsedJulianDays = dJulianDate - 2451545.0;
  }

  // Calculate ecliptic coordinates (ecliptic longitude and obliquity of the
  // ecliptic in radians but without limiting the angle to be less than 2*Pi
  // (i.e., the result may be greater than 2*Pi)
  {
    double dMeanLongitude;
    double dMeanAnomaly;
    double dOmega;
    dOmega = 2.1429 - 0.0010394594 * dElapsedJulianDays;
    dMeanLongitude = 4.8950630 + 0.017202791698 * dElapsedJulianDays; // Radians
    dMeanAnomaly = 6.2400600 + 0.0172019699 * dElapsedJulianDays;
    dEclipticLongitude = dMeanLongitude + 0.03341607 * sin( dMeanAnomaly ) + 0.00034894 * sin( 2 * dMeanAnomaly ) - 0.0001134 - 0.0000203 * sin(dOmega);
    dEclipticObliquity = 0.4090928 - 6.2140e-9 * dElapsedJulianDays + 0.0000396 * cos(dOmega);
  }

  // Calculate celestial coordinates ( right ascension and declination ) in radians
  // but without limiting the angle to be less than 2*Pi (i.e., the result may be
  // greater than 2*Pi)
  {
    double dSin_EclipticLongitude;
    dSin_EclipticLongitude = sin( dEclipticLongitude );
    dY = cos( dEclipticObliquity ) * dSin_EclipticLongitude;
    dX = cos( dEclipticLongitude );
    dRightAscension = atan2( dY, dX );
    if ( dRightAscension < 0.0 ) dRightAscension = dRightAscension + twopi;
    dDeclination = asin( sin( dEclipticObliquity ) * dSin_EclipticLongitude );
  }

  // Calculate local coordinates ( azimuth and zenith angle ) in degrees
  {
    double dGreenwichMeanSiderealTime;
    double dLocalMeanSiderealTime;
    double dLatitudeInRadians;
    double dHourAngle;
    double dCos_Latitude;
    double dSin_Latitude;
    double dCos_HourAngle;
    double dParallax;
    dGreenwichMeanSiderealTime = 6.6974243242 + 0.0657098283 * dElapsedJulianDays + dDecimalHours;
    dLocalMeanSiderealTime = (dGreenwichMeanSiderealTime * 15 + udtLocation.dLongitude) * rad;
    dHourAngle = dLocalMeanSiderealTime - dRightAscension;
    dLatitudeInRadians = udtLocation.dLatitude * rad;
    dCos_Latitude = cos( dLatitudeInRadians );
    dSin_Latitude = sin( dLatitudeInRadians );
    dCos_HourAngle = cos( dHourAngle );
    udtSunCoordinates->dZenithAngle = (acos( dCos_Latitude * dCos_HourAngle * cos(dDeclination) + sin( dDeclination ) * dSin_Latitude));
    dY = -sin( dHourAngle );
    dX = tan( dDeclination ) * dCos_Latitude - dSin_Latitude * dCos_HourAngle;
    udtSunCoordinates->dAzimuth = atan2( dY, dX );
    if ( udtSunCoordinates->dAzimuth < 0.0 )
      udtSunCoordinates->dAzimuth = udtSunCoordinates->dAzimuth + twopi;
    udtSunCoordinates->dAzimuth = udtSunCoordinates->dAzimuth / rad;
    // Parallax Correction
    dParallax = (dEarthMeanRadius / dAstronomicalUnit) * sin(udtSunCoordinates->dZenithAngle);
    udtSunCoordinates->dZenithAngle = (udtSunCoordinates->dZenithAngle + dParallax) / rad;
  }
}